#############################################################################################################################
#install libraries
#install.packages("plyr")
library(plyr)
#install.packages("dplyr")
library(dplyr)
#install.packages("readr")
library(readr)
#install.packages("psych")
library(psych)
#install.packages("ggplot2")
library(ggplot2)
#install.packages("ggpubr")
library(ggpubr)
#install.packages("geosphere")
library(geosphere)

#############################################################################################################################
#set working directory
setwd ("C:/Users/clyu/Desktop/GHG_CO2/Improving_inventory/V7_GRA2PES2021/Match_CEMS_NEI_EGU/spreadsheets/output_202105") #CHANGE

#############################################################################################################################
#read prepared .csv files
CEMS_202105_scaled_to_annual_tot <- read.csv("C:/Users/clyu/Desktop/GHG_CO2/Improving_inventory/V7_GRA2PES2021/Match_CEMS_NEI_EGU/spreadsheets/input_2021/CEMS_202105_scaled_to_annual_tot.csv")
CEMS_NEI_match_flat_202108 <- read.csv("C:/Users/clyu/Desktop/GHG_CO2/Improving_inventory/V7_GRA2PES2021/Match_CEMS_NEI_EGU/spreadsheets/output_202108/CEMS_NEI_match_flat_202108.csv")
CEMS_NEI_notmatch_Astack_202108 <- read.csv("C:/Users/clyu/Desktop/GHG_CO2/Improving_inventory/V7_GRA2PES2021/Match_CEMS_NEI_EGU/spreadsheets/output_202108/CEMS_NEI_notmatch_Astack_202108.csv")

#remove 202108 emissions from CEMS_NEI_match_flat_202108 and CEMS_NEI_notmatch_Astack_202108
CEMS_NEI_match_flat_2021 <- CEMS_NEI_match_flat_202108[,!names(CEMS_NEI_match_flat_202108) %in% c("Annual_NOx_Emis_MetricTon","Annual_CO2_Emis_MetricTon","Annual_SO2_Emis_MetricTon")]
CEMS_NEI_notmatch_Astack_2021 <- CEMS_NEI_notmatch_Astack_202108[,!names(CEMS_NEI_notmatch_Astack_202108) %in% c("Annual_NOx_Emis_MetricTon","Annual_CO2_Emis_MetricTon","Annual_SO2_Emis_MetricTon")]

#simplify CEMS_202105_scaled_to_annual_tot
CEMS_202105_scaled_to_annual_tot <- CEMS_202105_scaled_to_annual_tot[,!names(CEMS_202105_scaled_to_annual_tot) %in% c("LON","LAT","Fuel","Annual_Operating_Time_hr","Annual_Heat_Input_MMBtu")]

#add CEMS_202105_scaled_to_annual_tot emissions into the 2021 templates
CEMS_NEI_match_flat_202105 = join(CEMS_NEI_match_flat_2021,CEMS_202105_scaled_to_annual_tot, by=c("ORIS_ID","ORISPL","ORISUN"), type="left")
CEMS_NEI_notmatch_Astack_202105 = join(CEMS_NEI_notmatch_Astack_2021,CEMS_202105_scaled_to_annual_tot, by=c("ORIS_ID","ORISPL","ORISUN"), type="left")

#reorder columns in CEMS_NEI_match_flat_202105 and CEMS_NEI_notmatch_Astack_202105
CEMS_NEI_match_flat_202105 = subset(CEMS_NEI_match_flat_202105, select=c("ORIS_ID","ORISPL","ORISUN","LON_CEMS", "LAT_CEMS", "Fuel", "Annual_Operating_Time_hr","Annual_Heat_Input_MMBtu", "Annual_NOx_Emis_MetricTon", "Annual_SO2_Emis_MetricTon", "Annual_CO2_Emis_MetricTon","NEI_EGU_ID"))
CEMS_NEI_notmatch_Astack_202105 = subset(CEMS_NEI_notmatch_Astack_202105, select=c("ORIS_ID","ORISPL","ORISUN","LON_CEMS","LAT_CEMS","Fuel","Annual_Operating_Time_hr","Annual_Heat_Input_MMBtu","Annual_NOx_Emis_MetricTon","Annual_SO2_Emis_MetricTon","Annual_CO2_Emis_MetricTon","STKHGT","STKTEMP","STKFLOW","STKDIAM","STKVEL"))

write.csv(CEMS_NEI_match_flat_202105, file = "CEMS_NEI_match_flat_202105.csv")
write.csv(CEMS_NEI_notmatch_Astack_202105, file = "CEMS_NEI_notmatch_Astack_202105.csv")
